//								EJEMPLO 11
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//El Display de 7 segmentos
//
//Sobre el display de ctodo comn conectado a la puerta B, se desea visualiza el estado
//lgico "0" o "1" del interruptor RA0. Mediante el interruptor RA1 se activa o no el 
//punto decimal.

#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)

#byte port_a=5
#byte port_b=6

main()
{  
	SETUP_ADC_PORTS(NO_ANALOGS);	//Puerta A Digital
	set_tris_a(0x3F);				//RA0-RA5 entradas
	set_tris_b(0x00);				//RB0-RB7 salidas	   
	output_b (0x00);				//Borra las salidas

	while(1)
	{
		if (!bit_test(port_a,0))	//Chequea estado de RA0
		port_b = 0b00111111;		//Visualiza dgito 0
		else
		port_b = 0b00000110;		//Visuliza dgito 1
		if (!bit_test(port_a,1))	//Chequea estado de RA1
		output_low(PIN_B7);			//Desconecta punto decimal
		else
		output_high(PIN_B7);		//Activa punto decimal
	}
}	



